IF EXISTS (SELECT * FROM SYS.PROCEDURES WHERE NAME = 'P_LGPD_PROCESSAMENTO_CHQ')
BEGIN 
	DROP PROCEDURE P_LGPD_PROCESSAMENTO_CHQ
END 

GO 

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 21100101
'Job.................:  
'Nome................: P_LGPD_PROCESSAMENTO_CHQ 
'Objetivo............: Procedure responsavel pela anonimização de cheques - LGPD 
'Tabelas.............: CHQ_EMI, LGPD_LOG_PROCESSAMENTO
'Dt Criação..........: 
'Dt Ult Alteracão....: 01/10/2021
'Alterado por........: Marcos barros
'Criado por..........: Rayane
'=======================================================================================
Reg #21081901 - Alteração retorno RAISERROR  - Marcos Barros
Reg #21081901 - Alteração estrutura de insert em @NAO_ANONIMIZAR_DADOS - Marcos Barros
Reg #21100101 - Alteração tipo de dados retornado por parametro - Marcos Barros
*/
CREATE PROCEDURE P_LGPD_PROCESSAMENTO_CHQ (@CD_CHQ_EMI INT )
WITH ENCRYPTION
AS 
	SET NOCOUNT ON 
	DECLARE @NAO_ANONIMIZAR_DADOS TABLE (CD_CHQ_EMI INT, DESCRICAO VARCHAR(1000) );

	--Insere registro Pendente
	INSERT INTO @NAO_ANONIMIZAR_DADOS
 	SELECT  
		CHQ_LANC_CPL.CD_EMI,
		('NÃO PODE SER ANONIMIZADO: EMITENTE '+ CAST(@CD_CHQ_EMI AS VARCHAR) + ', COM CHEQUE EM ABERTO') AS DESCRICAO
	  FROM 
		PDV_VD
	    JOIN PDV_VD_CHQS ON 
				PDV_VD.CD_EMP    = PDV_VD_CHQS.CD_EMP   
			AND PDV_VD.CD_FILIAL = PDV_VD_CHQS.CD_FILIAL
			AND PDV_VD.CD_VD     = PDV_VD_CHQS.CD_VD  
		JOIN PDV_VD_CHQS_CHQ_LANC ON 
				PDV_VD_CHQS.CD_EMP    = PDV_VD_CHQS_CHQ_LANC.CD_EMP   						
 			AND PDV_VD_CHQS.CD_FILIAL = PDV_VD_CHQS_CHQ_LANC.CD_FILIAL
		 	AND PDV_VD_CHQS.CD_VD     = PDV_VD_CHQS_CHQ_LANC.CD_VD  
			AND PDV_VD_CHQS.NR_ORD    = PDV_VD_CHQS_CHQ_LANC.NR_ORD  
		JOIN CHQ_LANC_CPL ON 
				CHQ_LANC_CPL.CD_EMP = PDV_VD_CHQS_CHQ_LANC.CD_EMP
			AND CHQ_LANC_CPL.CD_CHQ = PDV_VD_CHQS_CHQ_LANC.CD_CHQ  
     WHERE 
		PDV_VD.CD_EMP = 1  
		AND CHQ_LANC_CPL.CD_EMI = @CD_CHQ_EMI 
		AND CHQ_LANC_CPL.STS_CHQ IN (0,1,2,5,6,7,9);

	--Valida se existe registro Pendente
	IF EXISTS (SELECT 1 FROM @NAO_ANONIMIZAR_DADOS  )
	BEGIN
		DECLARE @ERRORMESSAGE VARCHAR(MAX)= (SELECT DESCRICAO FROM ( SELECT T.DESCRICAO, ROW_NUMBER() OVER(ORDER BY CD_CHQ_EMI DESC) AS RowNumber FROM @NAO_ANONIMIZAR_DADOS T WHERE CD_CHQ_EMI = @CD_CHQ_EMI ) AS tmp WHERE RowNumber = 1);
		RAISERROR (@ERRORMESSAGE, 16, 1);
		RETURN;
	END 
	
/****************************************************************************************************************/

  
		PRINT 'ANONIMIZANDO EMITENTE DE CHEQUE';
			 
		UPDATE CHQ_EMI 
			SET  CGC_CPF			='000000000000'	
				,NM_EMI				='ANONIMIZADO'
				,END_EMI			='ANONIMIZADO'
				,FONE_EMI			='0000000000'
				,CEL_EMI			='0000000000'
				,EMAIL 				='ANONIMIZADO@ANONIMIZADO'
		FROM 
			CHQ_EMI 
		WHERE 
			CHQ_EMI.CD_EMI = @CD_CHQ_EMI  
			AND CHQ_EMI.TP_PESSOA = 0  

		INSERT INTO LGPD_LOG_PROCESSAMENTO  (CD_PESSOA,DT_CAD,NM_FM,TP_PROC)
		SELECT 
			@CD_CHQ_EMI					AS CD_CLI, 
			GETDATE()					AS DT_CAD,
			'P_LGPD_PROCESSAMENTO_CHQ'	AS NM_FM,
			1							AS TP_PROC

/****************************************************************************************************************/
